/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.ceutils;

import com.filenet.api.admin.IsolatedRegion;
import com.filenet.api.admin.PEConnectionPoint;
import com.filenet.api.collection.IsolatedRegionSet;
import com.filenet.api.collection.PEConnectionPointSet;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.Factory;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Encryption;
import com.filenet.api.util.Id;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.collection.AbstractEngineSet;
import com.filenet.apiimpl.util.J2EEUtil;
import filenet.pe.ceutils.ConnectionPoint;
import filenet.pe.ceutils.CryptoHelper;
import filenet.pe.peorb.client.JAASContext;
import filenet.vw.api.VWException;
import filenet.vw.base.PunycodeUtils;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWConvertTwo;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.Configuration;
import filenet.vw.server.VWBootstrapURL;
import filenet.vw.server.VWCORBANameURL;
import filenet.vw.server.VWRMIRouterURL;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.net.MalformedURLException;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Vector;
import javax.security.auth.Subject;

public class ConnectionPoints
implements PrivilegedExceptionAction {
    static final String m_className = "ConnectionPoints";
    protected static Logger logger = Logger.getLogger("filenet.pe.ceutils");
    private static final long serialVersionUID = 464L;
    private String m_ceURI = null;
    private String m_username = null;
    private String m_password = null;
    protected JAASContext m_myJAASContext = null;
    private Domain m_localDomain = null;
    private static PropertyFilter CP_PF = null;
    private String m_searchName = null;
    private VWCORBANameURL m_searchCorbaURL = null;
    private boolean m_searchMode = false;
    private boolean nameOnly = false;
    private char[] m_regionPW = null;
    private boolean wantIdentityToken = true;
    private ConnectionPoint m_cp;
    private boolean force = false;
    private String m_deleteCpName;
    private boolean needToAdd = false;
    private boolean needToUpdatePw = false;
    private static final int KEY_MASK = 0;

    public static String _get_FILE_DATE() {
        return "$Date:   08 Jan 2009 17:41:22  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.31  $";
    }

    private void setIsolatedRegionPW(String pw) {
        if (pw != null) {
            this.m_regionPW = pw.toCharArray();
        }
    }

    private static final String getPrivilegedSystemProperty(String propName) {
        final String fpropName = propName;
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(fpropName);
            }
        });
    }

    private void getDefaultCEURI() throws VWException {
        String m_method = "getDefaultCEURI";
        this.m_ceURI = ConnectionPoints.getPrivilegedSystemProperty("filenet.pe.bootstrap.ceuri");
        if (this.m_ceURI == null) {
            this.m_ceURI = Configuration.GetCEURI(null, null);
        }
        if (this.m_ceURI == null) {
            VWException vwe = new VWException("pe.ceutils.ConnectionPoints.NoBootstrapCEURI", "Failed to retrieve a boottrap CEURI");
            logger.throwing(m_className, "getDefaultCEURI", vwe);
            throw vwe;
        }
        this.m_ceURI = PunycodeUtils.toASCIIURL(this.m_ceURI);
        if (logger.isFinest()) {
            logger.finest(m_className, "getDefaultCEURI", this.m_ceURI);
        }
    }

    private void getDefaultUserNamePassword() {
        block5: {
            String m_method = "getDefaultUserNamePassword";
            try {
                String token = Configuration.GetProperty(null, null, "eProcessFlags");
                VWCMConvertTwo converter = new VWCMConvertTwo(0);
                VWAuthItem item = converter.getDString(token);
                if (item != null) {
                    this.m_username = item.getName();
                    this.m_password = item.getPassword();
                    if (this.m_password == null || this.m_password != null && this.m_password.compareTo("\"\"") == 0) {
                        this.m_password = "";
                    }
                    if (logger.isFinest()) {
                        logger.finest(m_className, "getDefaultUserNamePassword", this.m_username + "," + this.m_password.length());
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isFinest()) break block5;
                logger.finest(m_className, "getDefaultUserNamePassword", "Ignored this:" + e.getMessage());
            }
        }
    }

    protected void setNameOnly() {
        this.nameOnly = true;
    }

    protected void setSearchName(String name) {
        this.m_searchName = name;
        this.m_searchMode = true;
    }

    protected void setCORBASearchURL(VWCORBANameURL n) {
        this.m_searchCorbaURL = n;
        this.m_searchMode = true;
    }

    protected ConnectionPoints(String paramCEURI, Object paramUsername, String paramPassword) throws VWException {
        String m_method = "ctor";
        logger.entering(m_className, "ctor", new Object[]{paramCEURI, paramUsername});
        this.m_ceURI = paramCEURI;
        if (this.m_ceURI == null) {
            try {
                this.getDefaultCEURI();
            }
            catch (Exception e) {}
        } else {
            if (logger.isFinest()) {
                logger.finest(m_className, "ctor", "Looking at " + this.m_ceURI);
            }
            this.m_ceURI = PunycodeUtils.toASCIIURL(this.m_ceURI);
        }
        if (paramUsername != null && paramUsername instanceof JAASContext) {
            this.m_myJAASContext = (JAASContext)paramUsername;
            return;
        }
        this.m_password = paramPassword;
        if (paramUsername == null) {
            Subject subj = JAASContext.getCurrentUserContextSubject();
            if (subj != null) {
                this.m_myJAASContext = new JAASContext(subj, this.m_ceURI);
                return;
            }
            this.getDefaultUserNamePassword();
        } else {
            this.m_username = (String)paramUsername;
        }
        this.m_myJAASContext = JAASContext.getJAASContext(true, this.m_username, this.m_password, this.m_ceURI, "ConnectionPoint ctor");
    }

    public static ConnectionPoint[] GetConnectionPoints(String paramCEURI, String paramUsername, String paramPassword) throws VWException {
        ConnectionPoints cp = new ConnectionPoints(paramCEURI, paramUsername, paramPassword);
        return (ConnectionPoint[])cp.runEx();
    }

    public static ConnectionPoint[] GetConnectionPointsNoIdentityTokens(String paramCEURI, String paramUsername, String paramPassword) throws VWException {
        ConnectionPoints cp = new ConnectionPoints(paramCEURI, paramUsername, paramPassword);
        cp.wantIdentityToken = false;
        return (ConnectionPoint[])cp.runEx();
    }

    public static String[] GetConnectionPointNames(String paramCEURI, String paramUsername, String paramPassword) throws VWException {
        ConnectionPoints cp = new ConnectionPoints(paramCEURI, paramUsername, paramPassword);
        cp.setNameOnly();
        return (String[])cp.runEx();
    }

    public static ConnectionPoint[] GetAConnectionPointFromACorbaURL(VWCORBANameURL corbaURL, String paramCEURI, Object paramUsername, String paramPassword) throws VWException {
        ConnectionPoints cp = new ConnectionPoints(paramCEURI, paramUsername, paramPassword);
        cp.setCORBASearchURL(corbaURL);
        return (ConnectionPoint[])cp.runEx();
    }

    public static ConnectionPoint GetConnectionPointFromCPURI(String paramCEURI, String paramCPURI, Object paramUsername, String paramPassword) throws VWException {
        String m_method = "GetConnectionPointFromCPURI:" + paramCEURI + "," + paramCPURI;
        ConnectionPoint[] res = null;
        try {
            VWCORBANameURL corbaURL = new VWCORBANameURL(paramCPURI);
            res = ConnectionPoints.GetAConnectionPointFromACorbaURL(corbaURL, paramCEURI, paramUsername, paramPassword);
        }
        catch (Exception e) {
            try {
                VWRMIRouterURL rmiRouter = new VWRMIRouterURL(paramCPURI);
                paramCPURI = rmiRouter.getRouter();
                res = ConnectionPoints.GetAConnectionPointFromACPName(paramCPURI, paramCEURI, paramUsername, paramPassword);
            }
            catch (VWException vwe) {
                throw vwe;
            }
            catch (Throwable t) {
                throw new VWException(t);
            }
        }
        catch (Throwable t) {
            throw new VWException(t);
        }
        if (res != null && res[0] != null) {
            return res[0];
        }
        VWException vwe = new VWException("pe.ceutils.ConnectionPoints.ConnectionPointIsNotFound", "Connection Point {0} is not found for {1}.", paramCPURI, paramCEURI);
        throw vwe;
    }

    public static ConnectionPoint GetConnectionPointFromBootstrapURI(String url, Object paramUsername, String paramPassword) throws VWException, MalformedURLException {
        VWBootstrapURL bootstrapURL = new VWBootstrapURL(url);
        String paramCEURI = null;
        URI ceURI = bootstrapURL.getCEURI();
        if (ceURI != null) {
            paramCEURI = ceURI.toString();
        }
        String paramCPURI = bootstrapURL.getCPURI().toString();
        return ConnectionPoints.GetConnectionPointFromCPURI(paramCEURI, paramCPURI, paramUsername, paramPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runEx() throws VWException {
        Object object;
        if (this.m_ceURI != null && this.m_ceURI.equals("/FileNet/Local/Engine")) {
            return J2EEUtil.getInstance().doAs(this.m_myJAASContext.getSubject(), (PrivilegedExceptionAction)this);
        }
        UserContext old = UserContext.get();
        try {
            Subject s = this.m_myJAASContext.getSubject();
            UserContext uc = new UserContext();
            uc.pushSubject(s);
            UserContext.set((UserContext)uc);
            object = this.run();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            UserContext.set((UserContext)old);
            throw throwable;
        }
        UserContext.set((UserContext)old);
        return object;
    }

    public Object run() throws VWException {
        String m_method = "run";
        try {
            Connection conn;
            if (logger.isFinest()) {
                Subject s = J2EEUtil.getInstance().getCurrentSubject();
                logger.finest(m_className, "run", "J2EEUtil current subject=" + (s == null ? "Null" : s.toString()));
            }
            if ((conn = Factory.Connection.getConnection((String)this.m_ceURI)) != null) {
                this.m_localDomain = Factory.Domain.fetchInstance((Connection)conn, null, (PropertyFilter)CP_PF);
            }
            if (this.m_localDomain == null) {
                StringBuffer buf = new StringBuffer();
                buf.append(this.m_ceURI).append("Null CE domain object!!!");
                buf.append("\n").append(Logger.traceSystem());
                VWException vwe = new VWException("pe.ceutils.ConnectionPoints.noCEObject", "Failed to obtain a CE Connection or Domain Object.");
                buf.append("\n").append("Throwing:").append(VWException.DescribeThrowableCompletely(vwe));
                logger.severe(m_className, "run", buf.toString());
                throw vwe;
            }
            if (this.m_cp == null && this.m_deleteCpName == null) {
                if (this.nameOnly) {
                    return this.jaasGetCPNames();
                }
                return this.jaasGetConnectionPoints();
            }
            if (this.m_cp != null) {
                this.jaasAddOrUpdateConnectionPoint();
            } else {
                this.jaasRemoveConnectionPoint();
            }
            return null;
        }
        catch (VWException vwe) {
            throw vwe;
        }
        catch (Throwable t) {
            logger.throwing(m_className, "run", t);
            throw new VWException(t);
        }
    }

    private String[] jaasGetCPNames() {
        String m_method = "jaasGetCPNames";
        if (!this.nameOnly) {
            return null;
        }
        PEConnectionPointSet set = this.m_localDomain.get_PEConnectionPoints();
        int nCPs = ((AbstractEngineSet)set).getList().size();
        if (nCPs == 0) {
            return null;
        }
        Iterator iter = set.iterator();
        String[] res = new String[nCPs];
        int i = 0;
        while (iter.hasNext()) {
            PEConnectionPoint p = (PEConnectionPoint)iter.next();
            res[i] = p.get_Name();
            ++i;
        }
        if (logger.isFinest()) {
            logger.finest(m_className, "jaasGetCPNames", Logger.asString(res));
        }
        return res;
    }

    private ConnectionPoint[] jaasGetConnectionPoints() throws VWException {
        String m_method = "jaasGetConnectionPoints";
        PEConnectionPointSet set = this.m_localDomain.get_PEConnectionPoints();
        boolean usingCORBAURI = false;
        int nCPs = ((AbstractEngineSet)set).getList().size();
        if (nCPs == 0) {
            return null;
        }
        Iterator iter = set.iterator();
        Vector<ConnectionPoint> v = new Vector<ConnectionPoint>(nCPs);
        while (iter.hasNext()) {
            ConnectionPoint p2;
            block13: {
                PEConnectionPoint p = (PEConnectionPoint)iter.next();
                IsolatedRegion ir = p.get_IsolatedRegion();
                boolean grabIt = true;
                if (this.m_searchMode) {
                    grabIt = false;
                    usingCORBAURI = false;
                    if (this.m_searchName != null) {
                        grabIt = p.get_Name().equals(this.m_searchName);
                    } else if (this.m_searchCorbaURL != null) {
                        usingCORBAURI = grabIt = this.m_searchCorbaURL.getHost().equals(ir.get_DNSName()) && this.m_searchCorbaURL.getPort() == ir.get_BrokerPort().intValue() && this.m_searchCorbaURL.getRegion() == ir.get_IsolatedRegionNumber().intValue();
                    }
                }
                if (!grabIt) continue;
                p2 = new ConnectionPoint(p.get_Name(), ir.get_DNSName(), ir.get_BrokerPort(), ir.get_IsolatedRegionNumber(), this.m_ceURI);
                if (this.wantIdentityToken) {
                    try {
                        p2.IdentityToken = ir.getProperties().getBinaryValue("IdentityToken");
                    }
                    catch (Throwable e) {
                        Throwable t = VWException.getRealCause(e);
                        String regionDesc = ir.get_DNSName() + "," + ir.get_BrokerPort() + "," + ir.get_IsolatedRegionNumber();
                        VWString s = new VWString("pe.ceutils.ConnectionPoints.RegionHasNoPasswordSet", "Failed to retrieve Identity Token for Region {0}.  Server returns exception message: {1}.", regionDesc, t.getMessage());
                        logger.severe(m_className, "jaasGetConnectionPoints", s.toString());
                        if (!this.m_searchMode) break block13;
                        throw new VWException("pe.ceutils.ConnectionPoints.DefaultMessage", "Exception: {0}", s.toString());
                    }
                }
            }
            if (this.m_searchMode) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "jaasGetConnectionPoints", "Found " + p2);
                }
                v.add(p2);
                if (usingCORBAURI) continue;
                break;
            }
            if (logger.isFinest()) {
                logger.finest(m_className, "jaasGetConnectionPoints", "Grabbing " + p2.toString());
            }
            v.add(p2);
        }
        if (v.size() == 0) {
            return null;
        }
        return v.toArray(new ConnectionPoint[0]);
    }

    protected void setConnectionPointToAddOrUpdate(ConnectionPoint p, boolean force, boolean needToAdd, boolean needToUpdatePw) {
        this.force = force;
        this.needToAdd = needToAdd;
        this.needToUpdatePw = needToUpdatePw;
        this.m_cp = p;
    }

    protected void setConnectionPointNameToDelete(String name) {
        this.m_deleteCpName = name;
    }

    private void setCERegionPW(IsolatedRegion ir) {
        if (this.m_regionPW != null) {
            CryptoHelper.loadJCEProvider((EngineObject)ir);
            byte[] binaryData = Encryption.encrypt((EngineObject)ir, (char[])this.m_regionPW);
            ir.set_RegionPassword(binaryData);
            ir.save(RefreshMode.REFRESH);
        }
    }

    private static IsolatedRegion findCEIsolatedRegion(Domain domain, int regNum, String dnsName, int brokerPort) {
        IsolatedRegionSet irs = domain.get_IsolatedRegions();
        for (IsolatedRegion ir2 : irs) {
            if (ir2.get_IsolatedRegionNumber() != regNum || !ir2.get_DNSName().equalsIgnoreCase(dnsName) || ir2.get_BrokerPort() != brokerPort) continue;
            if (logger.isFinest()) {
                logger.finest("Found Isolated Region with " + dnsName + ":" + brokerPort + ", " + regNum);
            }
            return ir2;
        }
        return null;
    }

    private void jaasAddOrUpdateConnectionPoint() throws Exception {
        if (this.m_cp == null) {
            return;
        }
        System.out.println("Adding " + this.m_cp + "...");
        PEConnectionPoint cp = null;
        if (this.m_cp.Name != null) {
            cp = this.getPEConnectionPoint(this.m_cp.Name);
        }
        if (cp != null && !this.force) {
            String s = "Duplicate Connection Point Name:" + this.m_cp.Name;
            System.out.println(s);
            throw new Exception(s);
        }
        IsolatedRegion ir = ConnectionPoints.findCEIsolatedRegion(this.m_localDomain, this.m_cp.IsolatedRegionNumber, this.m_cp.DNSName, this.m_cp.BrokerPort);
        if (ir == null) {
            ir = Factory.IsolatedRegion.createInstance((Domain)this.m_localDomain, (Id)Id.createId());
            ir.set_DNSName(this.m_cp.DNSName);
            ir.set_IsolatedRegionNumber(new Integer(this.m_cp.IsolatedRegionNumber));
            ir.set_BrokerPort(new Integer(this.m_cp.BrokerPort));
            this.setCERegionPW(ir);
            ir.save(RefreshMode.REFRESH);
            System.out.println("Finished creating Isolated Region for " + this.m_cp);
        } else {
            if (this.needToUpdatePw) {
                this.setCERegionPW(ir);
            }
            ir.save(RefreshMode.REFRESH);
        }
        if (this.needToUpdatePw && !this.needToAdd) {
            return;
        }
        if (this.needToAdd) {
            if (cp == null) {
                cp = Factory.PEConnectionPoint.createInstance((Domain)this.m_localDomain, (Id)Id.createId());
                cp.set_Name(this.m_cp.Name);
                cp.set_DescriptiveText("PEConnectionPoint " + this.m_cp.Name);
            }
            cp.set_IsolatedRegion(ir);
            cp.save(RefreshMode.REFRESH);
            System.out.println("Done adding " + this.m_cp);
        }
    }

    private PEConnectionPoint getPEConnectionPoint(String name) {
        PEConnectionPointSet set = this.m_localDomain.get_PEConnectionPoints();
        for (PEConnectionPoint cp : set) {
            if (!cp.get_Name().equals(name)) continue;
            System.out.println("Found Connection Point " + name);
            return cp;
        }
        return null;
    }

    private void jaasRemoveConnectionPoint() throws Exception {
        if (this.m_deleteCpName == null) {
            return;
        }
        PEConnectionPoint cp = this.getPEConnectionPoint(this.m_deleteCpName);
        if (cp == null) {
            return;
        }
        System.out.println("Found " + this.m_deleteCpName + ".  Calling delete..");
        cp.delete();
        cp.save(RefreshMode.REFRESH);
    }

    public static ConnectionPoint[] GetAConnectionPointFromACPName(String name, String paramCEURI, Object paramUsername, String paramPassword) throws VWException {
        ConnectionPoints cp = new ConnectionPoints(paramCEURI, paramUsername, paramPassword);
        cp.setSearchName(name);
        return (ConnectionPoint[])cp.runEx();
    }

    public static void DeleteConnectionPoint(String name, String paramCEURI, Object paramUsername, String paramPassword) throws VWException {
        ConnectionPoints cp = new ConnectionPoints(paramCEURI, paramUsername, paramPassword);
        cp.setConnectionPointNameToDelete(name);
        cp.runEx();
    }

    public static void AddOrUpdateConnectionPoint(ConnectionPoint p, String isolatedRegionPw, String paramCEURI, Object paramUsername, String paramPassword, boolean wantAdd, boolean wantUpdatePw, boolean force) throws VWException {
        ConnectionPoints cp = new ConnectionPoints(paramCEURI, paramUsername, paramPassword);
        cp.setIsolatedRegionPW(isolatedRegionPw);
        cp.setConnectionPointToAddOrUpdate(p, force, wantAdd, wantUpdatePw);
        cp.runEx();
    }

    public static String GetCEURI(String url) throws VWException {
        String m_method = "GetCEURI:" + url;
        String paramCEURI = null;
        try {
            VWBootstrapURL bootstrapURL = new VWBootstrapURL(url);
            URI ceURI = bootstrapURL.getCEURI();
            if (ceURI != null) {
                paramCEURI = ceURI.toString();
            }
            if (paramCEURI == null) {
                paramCEURI = ConnectionPoints.getPrivilegedSystemProperty("filenet.pe.bootstrap.ceuri");
            }
            if (paramCEURI == null) {
                paramCEURI = Configuration.GetCEURI(null, null);
            }
            if (paramCEURI != null) {
                paramCEURI = PunycodeUtils.toASCIIURL(paramCEURI);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, paramCEURI);
        }
        return paramCEURI;
    }

    protected static void printUsage() {
        System.out.println("ConnectionPoints /ceServer <ceServerUri> /username <username> /pw <password> ");
        System.out.println(" [/create /force /name <Name> /peServer <peServer> /pePort <pePort> /regNum <regnum> /regPw <region password>]");
        System.out.println(" [/delete /name <Name>");
        System.out.println(" [/find /name <Name>");
        System.out.println(" [/updatePw /regNum <regnum> /peServer <peServer> /pePort <peport /regPw <region password>]");
        System.out.println(" [        Note that for finding, the name parameter can be eithera connection point name or a CORBAURL in the format of <corba://PEhost:PEport/Region#>");
        System.out.println(" OR put them all in a file and pass via /inputfile param");
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            String name;
            boolean wantFind;
            boolean wantDelete;
            String name2;
            VWCommandLineArgs c = new VWCommandLineArgs(args);
            if (c.isPresent("h") || c.isPresent("H") || c.isPresent("?")) {
                ConnectionPoints.printUsage();
            }
            String ceServer = c.getParameter("ceServer");
            String username = c.getParameter("username");
            String pw = c.getParameter("pw", "");
            if (ceServer == null || username == null) {
                ConnectionPoints.printUsage();
            }
            boolean wantCreate = c.isPresent("create");
            boolean wantUpdatePw = c.isPresent("updatePw");
            if (wantCreate || wantUpdatePw) {
                boolean force = c.isPresent("force");
                if (wantUpdatePw) {
                    force = true;
                }
                name2 = c.getParameter("name");
                String peServer = c.getParameter("peServer");
                int pePort = c.getIntParameter("pePort", 32776);
                int regNum = c.getIntParameter("regNum", -1);
                String regionPW = c.getParameter("regPw");
                if (peServer == null || regNum == -1 || name2 == null && wantCreate || regionPW == null && wantUpdatePw) {
                    ConnectionPoints.printUsage();
                }
                ConnectionPoints.AddOrUpdateConnectionPoint(new ConnectionPoint(name2, peServer, pePort, regNum, ceServer), regionPW, ceServer, username, pw, wantCreate, wantUpdatePw, force);
            }
            if (wantDelete = c.isPresent("delete")) {
                name2 = c.getParameter("name");
                ConnectionPoints.DeleteConnectionPoint(name2, ceServer, username, pw);
            }
            if ((wantFind = c.isPresent("find")) && (name = c.getParameter("name")) != null) {
                System.out.println("---Trying to find " + name + "...");
                try {
                    VWCORBANameURL corbaURL = new VWCORBANameURL(name);
                    ConnectionPoint[] res = ConnectionPoints.GetAConnectionPointFromACorbaURL(corbaURL, ceServer, username, pw);
                    int nCPs = res == null ? 0 : res.length;
                    System.out.println("Found " + nCPs + " for " + corbaURL);
                    for (int i = 0; i < nCPs; ++i) {
                        System.out.println("[" + i + "]=" + res[i]);
                    }
                }
                catch (Exception e) {
                    ConnectionPoint p = ConnectionPoints.GetConnectionPointFromCPURI(ceServer, name, username, pw);
                    System.out.println("FOUND -- " + p);
                }
            }
            System.out.println("--- Proceed to LIST ALL connection points now...");
            ConnectionPoints.printCPList(ceServer, ConnectionPoints.GetConnectionPoints(ceServer, username, pw));
            System.out.println("--- GetConnectionPointNames only...");
            String[] res = ConnectionPoints.GetConnectionPointNames(ceServer, username, pw);
            System.out.println("Got :" + Logger.asString(res));
        }
        catch (Throwable t) {
            System.out.println("------- main exception ?? ");
            t.printStackTrace();
        }
    }

    private static void printCPList(String ceServer, ConnectionPoint[] list) {
        int nCps = list == null ? 0 : list.length;
        System.out.println("Found " + nCps + " connection points on " + ceServer);
        for (int i = 0; i < nCps; ++i) {
            System.out.println(list[i]);
        }
    }

    static {
        CP_PF = new PropertyFilter();
        CP_PF.addIncludeProperty(10, null, null, "PEConnectionPoints", null);
        CP_PF.addIncludeProperty(2, null, null, "Name", null);
        CP_PF.addIncludeProperty(2, null, null, "IsolatedRegion", null);
        CP_PF.addIncludeProperty(3, null, null, "IsolatedRegions", null);
        CP_PF.addIncludeProperty(2, null, null, "BrokerPort", null);
        CP_PF.addIncludeProperty(2, null, null, "DNSName", null);
        CP_PF.addIncludeProperty(2, null, null, "IdentityToken", null);
        CP_PF.addIncludeProperty(2, null, null, "IsolatedRegionNumber", null);
    }

    final class VWCMConvertTwo
    extends VWConvertTwo {
        int KEY_MASK = 0;

        protected VWCMConvertTwo(int mask) {
            this.KEY_MASK = mask;
        }

        protected String getKey(int id) {
            return "MIIBCTCBtAIBADBPMQswCQYDeQQGEwJV6s4fUzEQMA4GA1UECBMHRmxvcmlkYTEYMBYGA1UEChMPRXllcyBvbiBUaGUgV2ViMRQwEgYDVQQDFAt3d3cuZXR3Lm5ldDBcMA0GCSqGSIb3DQEBAQUAA0sAMEgCQQCeojtjnHqg0GTxp+XZ56RaSe1iZWpumXjU6Sx7v1FdXzsY1oLOQa090Jtnu1WsQRHh0yDS+45oncjKm1zCIZAgMBAAGgADANBgkqhkiG9w0BAQQFAANBAFBj9g+NiUh8YWPrFGntgf4miUdwqUshptjJy4PjdsD*3ugy5avvuh3GPpGh2aYXIjHpJXTUBQyzxSEIINYtc";
        }

        protected String getEString(String name, String password) throws Exception {
            return super.getEString(name, password);
        }

        protected VWAuthItem getDString(String token) throws Exception {
            return super.getDString(token);
        }
    }
}

